/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import io.github.cottonmc.cotton.gui.impl.ScreenNetworkingImpl;
import io.github.cottonmc.cotton.gui.impl.client.LibGuiConfig;
import io.github.cottonmc.jankson.JanksonFactory;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibGuiClient
implements ClientModInitializer {
    public static final Logger logger = LogManager.getLogger();
    public static volatile LibGuiConfig config;
    public static final Jankson jankson;

    public void onInitializeClient() {
        config = LibGuiClient.loadConfig();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ScreenNetworkingImpl.SCREEN_MESSAGE_S2C, (client, networkHandler, buf, responseSender) -> ScreenNetworkingImpl.handle((Executor)client, (class_1657)client.field_1724, buf));
    }

    public static LibGuiConfig loadConfig() {
        try {
            JsonObject json;
            Path file = FabricLoader.getInstance().getConfigDir().resolve("libgui.json5");
            if (Files.notExists(file, new LinkOption[0])) {
                LibGuiClient.saveConfig(new LibGuiConfig());
            }
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                json = jankson.load(in);
            }
            config = (LibGuiConfig)jankson.fromJson(json, LibGuiConfig.class);
        }
        catch (Exception e) {
            logger.error("[LibGui] Error loading config: {}", (Object)e.getMessage());
        }
        return config;
    }

    public static void saveConfig(LibGuiConfig config) {
        try {
            Path file = FabricLoader.getInstance().getConfigDir().resolve("libgui.json5");
            JsonElement json = jankson.toJson((Object)config);
            String result = json.toJson(true, true);
            Files.write(file, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error("[LibGui] Error saving config: {}", (Object)e.getMessage());
        }
    }

    static {
        jankson = JanksonFactory.createJankson();
    }
}

